var selectedSSID = '';

var wifiConnectingState = false;
var wifiConnectingID = '';

var wifiData = new Array;
var wifiListExpanded = false;

function itemSelected(selectedSSIDTemp, cancelConnectingState)
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("itemSelected(selectedSSIDTemp=" + selectedSSIDTemp + ", cancelConnectingState=" + cancelConnectingState + ")");

	if(cancelConnectingState != false)
		wifiConnectingState = false;

	//Hide Tab Content
	selectedSSID = selectedSSIDTemp;
	//Deselect Menu Items
	$(".WiFiList li a").removeClass("currentTab");
	$(".WiFiList li a").removeClass("connectingTab");
	
	//Set menu item to selected.	
	
	//Get Current Signal Strength of selected item
	for(var i=0;i<wifiData.length;i++)
	{
		if(wifiData[i].ID == selectedSSID)
			$("#"+wifiData[i].ID).addClass("Signal"+wifiData[i].SignalStrength+"_Selected");
		else
			$("#"+wifiData[i].ID).removeClass("Signal"+wifiData[i].SignalStrength+"_Selected");		
	}

	if(wifiConnectingState)
		$("#"+selectedSSID).addClass("connectingTab");
	else
		$("#"+selectedSSID).addClass("currentTab");	
	
	if(selectedSSID == '')
		enableMainButton(false);
	else
		enableMainButton(true);
		
	translateUpdateItem(language, "ContentButtonText", "General.ConnectButtonText");
	setMainButtonStyle('Connect');
}
	
function setWiFiList()
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("setWiFiList");

	if (cef.application && cef.wireless)
	{
		var wirelessInfo = cef.wireless.GetInfo();
		
		if(wirelessInfo.Wlan.AvailableNetworks)
		{
			var wifiData = new Array;
			
			for(i=0;i<wirelessInfo.Wlan.AvailableNetworks.length;i++)
			{
				wifiData[i] = new Object;
				
				var IDWithoutSpaces = removeSpaces(wirelessInfo.Wlan.AvailableNetworks[i].Id);
				wifiData[i].ID = IDWithoutSpaces;
				wifiData[i].SSID = wirelessInfo.Wlan.AvailableNetworks[i].Ssid;
				wifiData[i].AUTH = wirelessInfo.Wlan.AvailableNetworks[i].SecurityAuthAlgorithm;
				wifiData[i].CIPH = wirelessInfo.Wlan.AvailableNetworks[i].SecurityCipherAlgorithm;
				wifiData[i].SignalStrength = GetWLanSigBarsFromPerc(wirelessInfo.Wlan.AvailableNetworks[i].SignalStrength);
				wifiData[i].HasProfile = wirelessInfo.Wlan.AvailableNetworks[i].HasProfile;
			}
			
			updateWiFiList(wifiData);
		}
	}
}
function removeSpaces(str){
		var newStr = '';
		for(var i=0;i<str.length; i++){
			if(str.slice(i,i+1) != ' '){
				newStr += str.slice(i,i+1);
			}
			
		}
		
		return newStr;
	}
	
	
function setWiFiList_Fake()
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("setWiFiList_Fake");

	var wifiData = new Array;
	wifiData[0] = new Object;
	wifiData[0].ID = "MySSID";
	wifiData[0].SSID = "Argus";
	wifiData[0].SignalStrength = 4;
	
	wifiData[1] = new Object;
	wifiData[1].ID ="SCOPEPRODUCTIONS";
	wifiData[1].SSID = "SCOPE PRODUCTIONS";
	wifiData[1].SignalStrength = 4;
	
	wifiData[2] = new Object;
	wifiData[2].ID ="MySSID3";
	wifiData[2].SSID = "fatcat";
	wifiData[2].SignalStrength = 3;
	
	wifiData[3] = new Object;
	wifiData[3].ID ="JimmysPizzaShack";
	wifiData[3].SSID = "SS Wireless";
	wifiData[3].SignalStrength = 2;
	
	wifiData[4] = new Object;
	wifiData[4].ID = "MissChu";
	wifiData[4].SSID = "MissChu";
	wifiData[4].SignalStrength = 1;
	
	wifiData[5] = new Object;
	wifiData[5].ID = "Thomson877tc";
	wifiData[5].SSID = "Thomson 877tc";
	wifiData[5].SignalStrength = 1;

	wifiData[6] = new Object;
	wifiData[6].ID = "router253";
	wifiData[6].SSID = "router 253";
	wifiData[6].SignalStrength = 1;
		
	wifiData[7] = new Object;
	wifiData[7].ID = "EmotumN3";
	wifiData[7].SSID = "homingpigeon";
	wifiData[7].SignalStrength = 1;
	
	wifiData[8] = new Object;
	wifiData[8].ID = "EmotumN4";
	wifiData[8].SSID = "EmotumN4";
	wifiData[8].SignalStrength = 0;
	
	wifiData[9] = new Object;
	wifiData[9].ID = "EmotumN5";
	wifiData[9].SSID = "jasonswifithingy";
	wifiData[9].SignalStrength = 0;
		
	wifiData[10] = new Object;
	wifiData[10].ID = "EmotumN6";
	wifiData[10].SSID = "Iris Pictures";
	wifiData[10].SignalStrength = 0;	
	
	updateWiFiList(wifiData);
}

function updateWiFiList(wifiDataTemp)
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("updateWiFiList(wifiDataTemp=" + wifiDataTemp + ")");


	wifiData = wifiDataTemp;
	//Clear list if already populated
	$('.WiFiList').empty();	
	
	var selectedIDStillInList = false;
	//Add new list items
	for(var i=0;i<wifiData.length;i++)
	{
		if(wifiData[i].ID == selectedSSID)
				selectedIDStillInList = true;
		
		var LiClass = "Signal"+wifiData[i].SignalStrength;
		$('.WiFiList').append('<li class="'+LiClass+'"><a  id="'+wifiData[i].ID+'" href="#" onClick="itemSelected(this.id)"  onDblClick="ConnectWiFi(this.id)"><div/>'+wifiData[i].SSID+'</a></li>');
	
	}
	
	if(!selectedIDStillInList)
	{
		//Disable connect button if selected item no longer exists
		selectedSSID = '';
		enableMainButton(false);	
	}
	else
		itemSelected(selectedSSID, false);
}

function ConnectWiFi_Result(result)
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("ConnectWiFi(result=" + result + ")");
		
	hideWiFiList();
}

function ConnectWiFi(id)
{
	//Connect button does send through ID but double clicking item does.
	if(id == undefined)
		id = selectedSSID;	

	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("ConnectWiFi(id=" + id + ")");

	var wifiNetworkItem;
	
	for(i=0; i<wifiData.length; i++)
	{
		if(wifiData[i].ID == id)
		{
			//window.cefWindow.OutputDebugString("ConnectWiFi2(id=" + wifiData[i].ID + ")");
			wifiNetworkItem = wifiData[i];
			break;
		}
	}	
		
	wifiConnectingState = true;
	wifiConnectingID = id;
	
	$(".WiFiList li a").removeClass("currentTab");
	$(".WiFiList li a").removeClass("connectingTab");
//$(".WiFiList li a").addClass("notConnecting");

	$("#"+id).removeClass("currentTab");
	//Get Current Signal Strength of selected item
	for(var i=0;i<wifiData.length;i++)
	{
		//	$("#"+wifiData[i].ID).removeClass("Signal"+wifiData[i].SignalStrength+"_Selected");
	}
	
	//Set menu item to selected.
	$("#"+id).addClass("connectingTab");
	$("#"+id).removeClass("notConnecting");
	
	//selectedSSID variable holds the selected item
	//$('.WiFiList li a').hide();
	
	//close window code
	//if(cef.application)
	//	cef.application.CloseSettingsWindow();

	if(cef.wireless)
	{
		enableMainButton(false);
		if(wifiNetworkItem.HasProfile)
		{
			cef.application.IncrimentUsage("Dialler.Wireless.Connect");
			cef.wireless.Connect(wifiNetworkItem.SSID);
		}
		else
		{
			cef.wireless.SetConnectInfo(wifiNetworkItem.SSID,
				wifiNetworkItem.AUTH, wifiNetworkItem.CIPH);
			cef.application.OpenNovusWindow(NovusWindowId_WifiSecKey);
		}
	}
}

function expandWiFiList()
{
	removeAdvertisement();
	translateUpdateItem(language, "ContentButtonText", "General.ConnectButtonText");
	setMainButtonStyle('Standard');//button mught look better grey in this instance
	enableMainButton(false);
	
			
	if(window.cefWindow)
	{
		setWiFiList();
		//window.cefWindow.OutputDebugString("expandWiFiList()");
	}
	else
		setWiFiList_Fake();

	wifiListExpanded = true;
	
	//$('.tabShell').css({'top' : '10px'});	
	$('#Content').css({'height' : '185px'});
	$('#ListShell').css({'visibility' : 'visible'});
	$('#ListShell').css({'opacity' : '1'});

	$('#Line1').css({'visibility' : 'hidden'});
	$('#Line2').css({'visibility' : 'hidden'});
	$('#Line3').css({'visibility' : 'hidden'});
}

function hideWiFiList()
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("hideWiFiList()");
		
	wifiListExpanded = false;
	
	itemSelected();
	//$('.tabShell').css({'top' : '110px'});	
	$('#Content').css({'height' : '74px'});
	$('#ListShell').css({'visibility' : 'hidden'});
	$('#ListShell').css({'opacity' : '0'});

	$('#Line1').css({'visibility' : 'visible'});
	$('#Line2').css({'visibility' : 'visible'});
	$('#Line3').css({'visibility' : 'visible'});
	
	//enableMainButton(true);
	WiFi_UpdateInfo();
	 UpdateAdvertisment();
}